{include file="header.tpl" title=$section.name keywords=$section.keywords description=$section.description}

<main class="main">

	<div class="flex:col">
		<div class="flex:col-max">
			{* breadcrumb *}
			{include file="modules/breadcrumb.tpl" class="bradcrumbs" boldLastItem=false noLastLink=true}
			{* /breadcrumb *}
		</div>
	</div>

	<section class="flex:col pad-tb-50">
		<div class="flex:col-max">

			<div class="grid:fr-1 g-gap-30">

				<div class="contacts">
					<div class="contacts__item">
						<div class="block-head">
							<div class="text-tmp title-40 txt-accent-6">
								<h1>{$section.name}</h1>
								{$section.content nofilter}
							</div>
						</div>

						<div class="contacts__list">
							<ul>
								<li>
									<div class="contacts__list-icon">
										<svg width="60" height="60" viewBox="0 0 60 60" fill="none" xmlns="http://www.w3.org/2000/svg">
											<rect width="60" height="60" rx="30" fill="#0F00C1" />
											<path d="M30 18C25.7829 18 22.2656 21.397 22.2656 25.7344C22.2656 27.3845 22.7615 28.8559 23.7131 30.2347L29.4081 39.1212C29.6844 39.5532 30.3162 39.5524 30.5919 39.1212L36.3116 30.2044C37.2428 28.8881 37.7344 27.3425 37.7344 25.7344C37.7344 21.4696 34.2647 18 30 18ZM30 29.25C28.0616 29.25 26.4844 27.6728 26.4844 25.7344C26.4844 23.796 28.0616 22.2188 30 22.2188C31.9384 22.2188 33.5156 23.796 33.5156 25.7344C33.5156 27.6728 31.9384 29.25 30 29.25Z" fill="white" />
											<path d="M35.4967 34.1576L31.9562 39.6929C31.0398 41.1218 28.9551 41.1171 28.0431 39.6943L24.4968 34.159C21.3766 34.8805 19.4531 36.202 19.4531 37.7813C19.4531 40.5217 24.8872 42 30 42C35.1128 42 40.5469 40.5217 40.5469 37.7813C40.5469 36.2009 38.6207 34.8786 35.4967 34.1576Z" fill="white" />
										</svg>
									</div>

									<div class="contacts__list-info">
										<div class="text-tmp title-18"><h3>Адрес</h3></div>
										<a href="">{$config.address}</a>
									</div>
								</li>

								<li>
									<div class="contacts__list-icon">
										<svg width="60" height="60" viewBox="0 0 60 60" fill="none" xmlns="http://www.w3.org/2000/svg">
											<rect width="60" height="60" rx="30" fill="#289E49" />
											<g clip-path="url(#clip0_140_11180)">
												<path d="M41.347 35.6136L37.9977 32.2643C36.8015 31.0681 34.768 31.5467 34.2896 33.1016C33.9307 34.1782 32.7346 34.7763 31.658 34.537C29.2657 33.9389 26.036 30.8289 25.4379 28.317C25.0791 27.2404 25.7968 26.0442 26.8733 25.6854C28.4284 25.2069 28.9068 23.1734 27.7107 21.9773L24.3614 18.628C23.4044 17.7907 21.969 17.7907 21.1317 18.628L18.859 20.9007C16.5863 23.293 19.0982 29.6327 24.7202 35.2547C30.3422 40.8767 36.6819 43.5083 39.0743 41.116L41.347 38.8432C42.1843 37.8863 42.1843 36.4509 41.347 35.6136Z" fill="white" />
											</g>
											<defs>
												<clipPath id="clip0_140_11180">
													<rect width="24" height="24" fill="white" transform="translate(18 18)" />
												</clipPath>
											</defs>
										</svg>
									</div>

									<div class="contacts__list-info">
										<div class="text-tmp title-18"><h3>Телефон</h3></div>
										{assign var=phones value=", "|explode:$config.phone}
										{foreach from=$phones item=phone name=phones}
											<a href="tel:{$phone|strip_phone}">{$phone|format_phone}</a>
										{/foreach}
									</div>
								</li>

								<li>
									<div class="contacts__list-icon">
										<svg width="60" height="60" viewBox="0 0 60 60" fill="none" xmlns="http://www.w3.org/2000/svg">
											<rect width="60" height="60" rx="30" fill="#5671FF" />
											<g clip-path="url(#clip0_140_11182)">
												<path d="M41.7885 22.7682L34.5098 30L41.7885 37.2318C41.92 36.9568 41.9999 36.6528 41.9999 36.3281V23.6719C41.9999 23.3472 41.92 23.0432 41.7885 22.7682Z" fill="white" />
												<path d="M39.891 21.5625H20.1098C19.7851 21.5625 19.4811 21.6423 19.2061 21.7739L28.509 31.03C29.3316 31.8525 30.6692 31.8525 31.4918 31.03L40.7947 21.7739C40.5197 21.6423 40.2157 21.5625 39.891 21.5625Z" fill="white" />
												<path d="M18.2114 22.7682C18.0798 23.0432 18 23.3472 18 23.6719V36.3281C18 36.6528 18.0798 36.9569 18.2114 37.2318L25.4901 30L18.2114 22.7682Z" fill="white" />
												<path d="M33.516 30.9943L32.486 32.0242C31.1154 33.3948 28.8853 33.3948 27.5147 32.0242L26.4848 30.9943L19.2061 38.2261C19.4811 38.3577 19.7851 38.4375 20.1098 38.4375H39.891C40.2157 38.4375 40.5197 38.3577 40.7947 38.2261L33.516 30.9943Z" fill="white" />
											</g>
											<defs>
												<clipPath id="clip0_140_11182">
													<rect width="24" height="24" fill="white" transform="translate(18 18)" />
												</clipPath>
											</defs>
										</svg>
									</div>

									<div class="contacts__list-info">
										<div class="text-tmp title-18"><h3>Почта</h3></div>
										<a href="mailto:{$config.email}">{$config.email}</a>
										<a href="mailto:ceo@maxxpharm.com">CEO@maxxpharm.com</a>
										<a href="mailto:hr@maxxpharm.com">hr@maxxpharm.com</a>
									</div>
								</li>
							</ul>
						</div>

					</div>

					<div class="contacts__item">

						<div class="common-form bg-accent-3">

							{* Нужна помощь form feedback *}
							{include file="form/feedback-form.tpl"}
							{* /Нужна помощь form feedback *}

							<div class="text-tmp txt-accent-6">
								<p>Отправляя заявку вы даёте согласие на обработку персональной информации.</p>
							</div>

						</div>

					</div>

				</div>

				<div class="map" id="map"></div>

			</div>

		</div>
	</section>


	{* Call центр *}
	{include file="blocks/call-center.tpl"}
	{* /Call центр *}

	{* Подписаться на Рассылку *}
	{include file="blocks/newsletter.tpl"}
	{* /Подписаться на Рассылку *}

</main>

{include file="footer.tpl"}