<!DOCTYPE html>
<html lang="{$config.website_language}">
<head>
	{include file="modules/meta.tpl"}
    {include file="modules/link.tpl"}
	{include file="modules/recaptcha.tpl"}

</head>

<body>

{fetch_sections assign=headerMenus status="V" topMenu=1 level=1}
<header class="header">

	<div class="header__item">
		<div class="flex:col-max">
			<div class="header__item-inner">

				{logo link=true classLink="header__logo"}

				<div class="header__search">
					<form class="header__search-form" action="{$SITE_URL}/search.php">

						<div class="input"><input type="text" name="query" value="{$query}" placeholder="Поиск"></div>

						<button class="header__search-btn" type="submit">
							<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M18.7801 17.7196L13.6614 12.6009C14.6529 11.3762 15.2499 9.81994 15.2499 8.12496C15.2499 4.19649 12.0534 1 8.12493 1C4.19645 1 1 4.19645 1 8.12493C1 12.0534 4.19649 15.2499 8.12496 15.2499C9.81994 15.2499 11.3762 14.6529 12.6009 13.6614L17.7196 18.7801C17.8659 18.9264 18.0579 18.9999 18.2499 18.9999C18.4419 18.9999 18.6339 18.9264 18.7802 18.7801C19.0734 18.4869 19.0734 18.0129 18.7801 17.7196ZM8.12496 13.7499C5.02297 13.7499 2.5 11.2269 2.5 8.12493C2.5 5.02294 5.02297 2.49997 8.12496 2.49997C11.227 2.49997 13.7499 5.02294 13.7499 8.12493C13.7499 11.2269 11.2269 13.7499 8.12496 13.7499Z" />
							</svg>
						</button>

					</form>
				</div>

				<div class="header__lang">
					<ul>
						<li>
							<button>Ru</button>
							<ul>
								<li><a href="{$GLOBAL_URL}/uz/">Uz</a></li>
								<li><a href="{$GLOBAL_URL}/en/">En</a></li>
							</ul>
						</li>
					</ul>
				</div>

				<div class="header__contacts">
					<ul>
						{assign var=phones value=", "|explode:$config.phone}
						{foreach from=$phones item=phone name=phones}
							<li><a href="tel:{$phone|strip_phone}"><span>Тел:</span> {$phone|format_phone}</a></li>
						{/foreach}
					</ul>
				</div>

				<button class="header__btn header-btn_js">
                    <span class="burger-btn burger-btn_short">
                        <span class="burger-btn__item"></span>
                    </span>
				</button>

			</div>
		</div>
	</div>

	<div class="header__item" style="background-image: url('{$ASSETS_URL}/images/bg/pathern.svg');">
		<div class="flex:col-max">
			<div class="header__item-inner">

				<nav class="header__nav">
					<ul>
						{foreach item=headerMenu from=$headerMenus name=headerMenus key=$key}
							<li><a {if isset($section.sectionId) && $section.sectionId eq $headerMenu.sectionId}class="active"{/if} href="{if !empty($headerMenu.externalLink)}{$headerMenu.externalLink}{else}{$SITE_URL}{$headerMenu.url}{/if}">{$headerMenu.alias}</a></li>
						{/foreach}
					</ul>
				</nav>

			</div>
		</div>
	</div>

	<div class="header-mob header-mob_js">
		<div class="header-mob__inner">

			<div class="header-mob__head">

				{logo link=true classLink="header-mob__logo"}


				<div class="header-mob__lang">
					<ul>
						<li><span>Ru</span></li>
						<li><a href="{$GLOBAL_URL}/uz/">Uz</a></li>
						<li><a href="{$GLOBAL_URL}/en/">En</a></li>
					</ul>
				</div>

			</div>

			<div class="header-mob__content">
				<div class="header-mob__nav">
					<ul>
						{foreach item=headerMenu from=$headerMenus name=headerMenus key=$key}
							<li><a {if isset($section.sectionId) && $section.sectionId eq $headerMenu.sectionId}class="active"{/if} href="{if !empty($headerMenu.externalLink)}{$headerMenu.externalLink}{else}{$SITE_URL}{$headerMenu.url}{/if}">{$headerMenu.alias}</a></li>
						{/foreach}
					</ul>
				</div>
			</div>

			<div class="header-mob__footer">
				<div class="header-mob__contacts">
					<ul>
						<li><a href="mailto:{$config.email}">{$config.email}</a></li>
						<li><a href="mailto:ceo@maxxpharm.com">CEO@maxxpharm.com</a></li>
						<li><a href="mailto:hr@maxxpharm.com">hr@maxxpharm.com</a></li>
						{assign var=phones value=", "|explode:$config.phone}
						{foreach from=$phones item=phone name=phones}
							<li><a href="tel:{$phone|strip_phone}"><span>Тел:</span> {$phone|format_phone}</a></li>
						{/foreach}
					</ul>
				</div>

				<div class="social">
					{include file="modules/socials.tpl" path="/images/icons/social/"}
				</div>
			</div>

		</div>
	</div>

</header>