<?php
/******************************************************************************/
//                                                                            //
//                             Smarty plugin                                  //
//                            @package Smarty                                 //
//							 @subpackage plugins                              //
//                        http://life-style.uz/                               //
//                   produced by Life Style, life-style.uz                    //
//                                                                            //
/******************************************************************************/

function smarty_function_fetch_brands($params, &$smarty)
{
	$assign        = fetch_getParam('assign', $params, 'brands');
	$fields        = fetch_getParam('fields', $params, 'brandId, publishedOn, name, fileName, url, content, orderBy, isFeatured');
	$status        = fetch_getParam('status', $params, 'V');
	$limit         = (int) fetch_getParam('limit', $params, 10);
	$perPage       = (int) fetch_getParam('perPage', $params, $limit);
    $isFeatured    = fetch_getParam('isFeatured', $params, NULL);
	
	$query         = fetch_getParam('query', $params, NULL);
	$match         = fetch_getParam('match', $params, 'any');
	$order         = fetch_getParam('order', $params, NULL);
	$orderBy       = fetch_getParam('orderBy', $params, $order);

	$page          = (int) fetch_getParam('page', $params);

    $letters       = (bool) fetch_getParam('letters', $params, false);
    $alphabet     = fetch_getParam('alphabet', $params, NULL);
    $group        = fetch_getParam('group', $params, '');
	
	$image        = (bool) fetch_getParam('image', $params, false);
    $imageType    = fetch_getParam('imageType', $params, 'general');
	
	
	$assignPagination = fetch_getParam('assignPagination', $params);
	$path             = fetch_getParam('path', $params);
	$seFriendly       = (boolean) fetch_getParam('seFriendly', $params);
	$pnFirst          = (int) fetch_getParam('pnFirst', $params, 0);
	$pnBefore         = (int) fetch_getParam('pnBefore', $params, 4);
	$pnAfter          = (int) fetch_getParam('pnAfter', $params, 4);
	$pnLast           = (int) fetch_getParam('pnLast', $params, 0);
	
	if (empty($assign)) {
		$smarty->_trigger_fatal_error('fetch_brands: "assign" must not be empty');
		return;
	}
	
	if (empty($path)) $path = array();

	/* conditions */
    filterBrand($status, $orderBy, $isFeatured, $query, $group, $alphabet);
//    if(!is_null($query) && is_array($path)) $path[] = "query = " . urlencode($query);
    /* query conditions */
	fetch_brands_addQueryConditions($query, $match, $where, $fields, $orderBy);

	if ($page < 1) $page = 1;

	$brands = connect()->table('brands')->select($fields)->pagination($perPage, $page)->getAll('array');
    if ($image == true) {
        $brands = prepareBrands($brands, $imageType);
    }

	if ($letters == true) {
        $brands = prepareLettersBrands($brands);
    }

//	print_r($brands);
	$smarty->assign($assign, $brands);
	
	if (!empty($assignPagination)) {
        filterBrand($status, $orderBy, $isFeatured, $query, $group, $alphabet);
        if(!is_null($query) && is_array($path)) $path[] = "query = " . urlencode($query);
        /* query conditions */
        fetch_brands_addQueryConditions($query, $match, $where, $fields, $orderBy);
		/* page numbering */
		$total = connect()->table('brands')->count('*','count')->getValue();
		if (is_array($path)) {
			$path = SITE_URL.'/'.basename($_SERVER['PHP_SELF']).'?'.(!empty($path) ? implode('&', $path).'&' : '');
			$seFriendly = false;
		}
		$pagination = getPageNums($total, $page, $perPage, $pnFirst, $pnBefore, $pnAfter, $pnLast, $path, $seFriendly);
		$smarty->assign($assignPagination, $pagination);
	}
	
	return null;
}


function filterBrand($status, $orderBy, $isFeatured, $query, $group, $alphabet)
{
    global $gmNow;

    connect()->where('publishedOn','<=', $gmNow);
    if(!empty($status)) connect()->where('status', $status);
    if (!is_null($isFeatured)) connect()->where('isFeatured',$isFeatured ? 1 : 0);

    if(is_null($orderBy)) {
        connect()->orderBy(is_null($query) ? 'name ASC' : 'name');
    }

    if (!empty($group)) {
        if ($group == 'ru') {
            connect()->where('name','REGEXP', '[а-яА-Я]');
        } elseif($group == 'en') {
            connect()->where('name','REGEXP', '[a-zA-Z]');
        } elseif($group == 'num') {
            connect()->where('name','REGEXP', '[0-9]');
        }
    }
    if (!empty($alphabet)) connect()->where('name','REGEXP', "^$alphabet");

}
?>