<?php

namespace Mnv\Modules\Payment\Paybox;

use Mnv\Core\DB;

class PayBoxApi
{

    /**
     * Идентификатор мерчанта в PayBox.money. Выдается при подключении.
     * @var string
     */
    const MERCHANTID = '542619';

    /**
     * Время (в секундах) в течение которого платеж должен быть завершен
     *
     * @var int
     * Default: "86400"
     * Минимально допустимое значение: 300 секунд (5 минут).
     * Максимально допустимое значение: 604800 секунд (7 суток)
     */
    const TRANSACTION_LIFETIME = 300;

    /**
     * Секретный ключ для приема платежей
     */
    const SECTETKEY = 'fGs7tiztCCgMRCWm';

    /**
     * Секретный ключ для выплат клиентам
     */
    const SECTETKEYPAYOUT = 'WS29lxdLF2ALHTI1';

    /**
     * @var string sandbox/life
     */
    const MODE = 'sandbox';

    /**
     * Валюта, в которой указана сумма. KZT, USD, EUR.
     * В случае выбора покупателем способа платежа в другой валюте, производится пересчет по курсу ЦБ на день платежа.
     *
     * @var $currency
     */
    public $currency;

    /**
     * Идентификатор платёжной системы. EPAYWEBKZT
     * @var $payment_system
     */
    public $payment_system;

    public $order;
    public $payment;
    public $product;

    public function __construct()
    {

        $this->payment_system = '';
    }


    public function getOrder($orderId)
    {
        $this->order = DB::init()->connect()->table('shop_orders')->select('order_id, amount, status, state')->where('order_id',  $orderId)->get('array');
        $this->order['products'] = DB::init()->connect()->table('shop_order_products')->where('order_id', $orderId)->getValue();

    }

    public function checkOrder($orderId)
    {
        if (DB::init()->connect()->table('shop_orders')->where('order_id', $orderId)->get('array')) return true;

        return false;
    }

    public function updateOrder($orderId, $status, $state)
    {
        $params['status'] = $status;
        $params['state'] = $state;
        if (DB::init()->connect()->table('shop_orders')->where('order_id', $orderId)->update($params)) return true;

        return false;
    }

    public function getProducts($productId)
    {
        return DB::init()->connect()->table('products')->select('productId, title')->where('productId', $productId)->get('array');
    }

    public function getDefaultCurrency()
    {

        $this->currency = DB::init()->connect()->table('shop_currency')->select('codeName')->where('isDefault', 1)->getValue();
    }

    /**
     * @param $amount
     * @return float|mixed
     */
    public function convertMoney($amount)
    {
        if ($course = DB::init()->connect()->table('shop_currency')->select('course')->where('codeName', $this->currency)->getValue())
        {
            return round($amount / $course,2);
        }

        return $amount;

    }
}