<?php

namespace Mnv\Modules\Payment\Apelsin\Form;

use Mnv\Modules\Payment\PaymentMethodService;
use Mnv\Modules\Payment\PaymentMethodInterface;

final class ApelsinGenerationForm implements PaymentMethodInterface
{

    const RETURN_URL = SITE_URL;
    private $cashId;
    private $url;

    public function __construct()
    {

        $payment = new PaymentMethodService('apelsin');
        $this->cashId = $payment->payment_method['settings']['cashId'];

//        $this->url = ($this->payment_method->settings->mode == 'live') ? 'https://oplata.kapitalbank.uz' : 'https://oplata.kapitalbank.uz';
    }

    public function form($payment): ?string
	{
    	 
		if (!$payment['order_id']) return null;

        $button = '<button type="submit" class="send">Перейти к оплате</button>';
		if ($payment['auto']) {
            $button = '';
            $auto = '<script type="text/javascript">apelsinPayment.submit()</script>';
		}
        
		$fields = $this->fields($payment);

        return <<<HTML
<form method="GET" action="https://oplata.kapitalbank.uz" name="apelsinPayment" target="_blank">
{$fields}
{$button}
</form>
{$auto}
HTML;

	}


    public function fields($payment): string
    {

		$date   = date("Y-m-d h:i:s");
//		$amount = number_format($amount, 2, '.', '');
       
		$fields = array(
			'cash'          => $this->cashId,  // уникальный Cash ID (выдается Апельсином)
			'redirectUrl'   => ApelsinGenerationForm::RETURN_URL,    // URL для отправки на сайт после оплаты
			'description'   => 'Оплата за участие',         // фраза, который выйдет на экране оплаты у Пользователя, например «Пополнение платежа на www._______.uz»
			'amount'        => $payment['amount'].'00', // в тийинах
			'userid'        => $payment['user_id'],
			'cabinetid'     => $payment['order_id'], // в зависимости от типа поля, например номер договора
		);
        
		$html = '';

		foreach ($fields as $field => $val) {
			$html .= '<input type="hidden" name="' . $field . '" value="' . $val . '" />' . PHP_EOL;
		}

		return $html;
	}
	
}

//<form method="GET" action="https://oplata.kapitalbank.uz"> // Обязательные поля
//<input type="hidden" name="cash" value=""/> // уникальный Cash ID (выдается Апельсином)
//<input type="hidden" name="redirectUrl" value=""/> // URL для отправки на сайт после оплаты
//<input type="hidden" name="description" value=""/>
//// фраза, который выйдет на экране оплаты у Пользователя, например «Пополнение платежа на www._______.uz»
//// Предусматривается установка дополнительных полей для Клиента. После проведения платежа, данные по полям будут отправляться на ваш биллинг URL в формате JSON.
//// В JSON не будет required/optional полей
//// В JSON будут поля amount (сумма оплаты Пользователя) и transactionId (уникальный айди транзакции)
//<input type="hidden" name="amount" value=""/>
// <input type="hidden" name="" value=""/>
//<input type="hidden" name="" value=""/>
//...
//<button type="submit" style="cursor: pointer; border: 1px solid #ebebeb; border-radius: 6px; background: linear-gradient(to top, #f1f2f2, white); width: 100px; height: 54px; display: flex; align-items: center; justify-content: center;">
//<img style="width: 100px; height: 42px;" src="https:// oplata.kapitalbank.uz/images/humo.png">
//</button>
//</form>
