<?php


namespace Mnv\Modules;

/**
 * Class Projects
 * @package Mnv\Modules
 */
class Clients
{

    public $response = [];

    private $section_id;
    private $company_id;
    private $page;
    private $limit;

    public $clients = [];

    public function __construct($section_id, $company_id, $page, $limit = 10)
    {
        $this->section_id = $section_id;
        $this->company_id = $company_id;
        $this->page = $page;
        $this->limit = $limit;
    }

    public function all()
    {
        if (!empty($this->company_id)) {
            connect()->grouped(function($q) {
                $q->like('companyIds', "%$this->company_id%");
//            $q->like('ABS(companyIds)', "%$company%")->orLike('ABS(companyIds)', "$company%")->orLike('ABS(companyIds)',"%$company");
            });
        }
        if (!empty($this->section_id)) {
            connect()->where('sectionId', $this->section_id);
        }

        $this->clients = connect('clients')->select('*')->where('status', 'V')->orderBy('publishedOn DESC')->pagination($this->limit, $this->page)->getAll('array');
        $this->clients = prepareClients($this->clients, true, false, true, 'general');
        foreach ($this->clients as $client) {
            $client['summary'] = $this->internoetics_string_strrpos(strip_tags($client['summary']));
        }

    }

    /**
     * @param $string
     * @param int $length
     * @param string $trimmarker
     * @return string
     */
    private function internoetics_string_strrpos($string, $length = 137, $trimmarker = '...'): string
    {
        $len = strlen(trim($string));
        return ($len > $length) ? rtrim(substr($string, 0, strrpos(substr($string, 0, $length), ' '))) . $trimmarker : $string;
    }
}