<?php

namespace Mnv\Models\Users;

/**
 * Class UserSettingOption
 * @package Mnv\Models
 */
class UserSettingOption
{
    /** @var string */
    protected string $table = 'user_option';

    /** @var string  */
    protected string $primaryKey = 'id';

    /** @var int|null  */
    public ?int $id ;

    /** @var array  */
    public $option = [];

    /** @var array  */
    public array $selected_columns = [];

    /** @var string  */
    public string $order_field;

    /** @var string  */
    public string $order_direction;

    protected $options = [];

    public function __construct($table, $userId)
    {
        $this->getOption($table, $userId);
    }

    public function getOption($table, $userId): void
    {
        if (!empty($userId) && $options = connect()->table('user_option')->where('name', $table)->where('userId', $userId)->get('array')) {
            if (!empty($options['value'])) {
                $this->options = json_decode($options['value'], true);
            }
        }
    }

    public function getVisibleColumns()
    {
        if(!empty($this->options["columns"])) {
            return $this->options["columns"];
        }
        return [];
    }


    /**
     * Функция возвращает варианты товара
     * @param int $userId
     * @return array|mixed|null
     */
    public function all(int $userId)
    {
        if (!empty($userId)) {
            return connect()->table($this->table)->where('userId', $userId)->orderBy('orderBy')->indexKey($this->primaryKey)->getAllIndexes('array');
        }

        return null;
    }

    public function get($table, $userId): void
    {
        if (!empty($userId) && $this->option = connect()->table($this->table)->where('name', $table)->where('userId', $userId)->get('array')) {
            if (!empty($this->option['value'])) {
                $this->option['value'] = json_decode($this->option['value'], true);

                $this->selected_columns = $this->option['value']['columns'];
                $this->order_field      = $this->option['value']['order_field'];
                $this->order_direction  = $this->option['value']['order_direction'];
            }
        }
    }

    public function checkFileName(string $name, int $managerId): bool
    {
        if ($this->id = connect()->table($this->table)->select('id')->where('name', $name)->where('userId', $managerId)->getValue()) {
            return true;
        }

        return false;
    }

    public function prepare(string $table, array $options, int $managerId)
    {
        $options = !empty($options) ? json_encode($options) : NULL;

        $option = [
            'userId' => $managerId,
            'name'   => $table,
            'value'  => $options
        ];

        $this->checkFileName($table, $managerId);

        if ($this->checkFileName($table, $managerId) && !empty($this->id)) {
           return connect()->table($this->table)->where($this->primaryKey, $this->id)->update($option);
        }

        return connect()->table($this->table)->insert($option);
    }



    public function remove(int $id): void
    {
        connect()->table($this->table)->where($this->primaryKey, $id)->delete();
    }
}