<?php

namespace Mnv\Models;

use Mnv\Core\Model;
use Mnv\Http\Request;

/**
 * Class AdvertisingBanners
 * @package Mnv\Models
 */
class AdsBanner extends Model
{

    /** @var string */
    protected string $table = 'ads_banners';
    /** @var string  */
    protected string $primaryKey = 'bannerId';

    /** @var string  */
    protected string $orderBy = 'bannerId ASC';


    public function __construct(Request $request)
    {
        $this->id   = $request->get('id');
        $this->data = $request->get('banner', '');
    }

    public function prepare(array $data, int $managerId): bool
    {

        if (empty($this->id)) {

            if ($this->id = $this->insert($data)) {
                return true;
            }
        }
        else {
            return $this->update($data);
        }

        return false;
    }

    /**
     * Удаление баннера
     * @return bool
     */
    public function remove(): bool
    {
        if (!empty($this->id) && $bannerFile =  connect()->table($this->table)->select('fileUrl')->where($this->primaryKey, $this->id)->getValue()) {
            if (!empty($bannerFile)) @unlink(SITE_ROOT . '/' . $bannerFile);
            connect()->table($this->table)->where($this->primaryKey, $this->id)->delete();

            return true;
        }

        return false;
    }


    public function checkFileName(?string $fileName)
    {
        // TODO: Implement checkFileName() method.
    }

}