<?php


namespace Mnv\Core\Test;


class ErrorReporting
{
    private static $messages = [];
    private static $initiated = false;
    private static $enable_logging = false;


    public static function init($enable_logging = false)
    {
        if (static::$initiated) {
            return;
        }

        if ($enable_logging == true) {
            var_dump($enable_logging);
            static::$enable_logging = true;
        }

        error_reporting(0);

        set_error_handler(function (int $errno, string $errstr, string $errfile, int $errline) {
            static::echo([
                'error' => ['line' => $errline, 'file' => $errfile, 'msg' => $errstr],
                'trace' => debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS)
            ]);
//            var_dump(static::$enable_logging);

            if (static::$enable_logging === true) {
                $file = GLOBAL_ROOT . "/temp/log/errorlog.txt";

                file_put_contents($file, json_encode([
                    'error' => [
                        'line' => $errline,
                        'file' => $errfile,
                        'msg' => $errstr
                    ],
                    'trace' => debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS)
                ], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT), FILE_APPEND | LOCK_EX);

            }
        }, E_ALL | E_STRICT);


        register_shutdown_function(function () {
            $error = error_get_last();
            if ($error !== null) {

                static::echo([
                    'error' => [
                        'line' => $error['line'],
                        'file' => $error['file'],
                        'msg' => $error['message']
                    ],
                    'trace' => debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS)
                ]);

                if (static::$enable_logging === true) {

                    $file = GLOBAL_ROOT . "/temp/log/errorlog.txt";

                    file_put_contents($file, json_encode([
                        'error' => ['line' => $error['line'], 'file' => $error['file'], 'msg' => $error['message']],
                        'trace' => debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS)
                    ], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT), FILE_APPEND | LOCK_EX);
                }
            }
        });

        static::$initiated = true;
    }


    public static function echo($args, bool $use_var_dump = true, bool $auto_exit = false)
    {
        if ($use_var_dump) {
            print "<pre>" . print_r($args) . "</pre>";
        } else {
            print "<pre>" . json_encode($args, JSON_PRETTY_PRINT) . "</pre>";
//            echo "<pre>", json_encode($args, JSON_PRETTY_PRINT | JSON_INVALID_UTF8_SUBSTITUTE), "</pre>";
        }
        if ($auto_exit) {
            exit(1);
        }
    }

    public static function addError($err)
    {
        static::$messages[] = $err;
    }

    public static function getErrors(): array
    {
        return static::$messages;
    }

    public static function hasErrors(): bool
    {
        return count(static::$messages) > 0;
    }

    public static function resetErrors()
    {
        static::$messages = [];
    }

    public static function echoErrors(): void
    {
        static::echo(static::$messages);
    }
}