<?php

namespace Mnv\Core;

use Mnv\Http\Request;
use Mnv\Core\Utilities\Cookie\Cookie;

/**
 * Class Mnv
 * @package Mnv\Models
 */
class Mnv
{
    /** @var Design  */
    public Design $smarty;

    /** @var array|mixed|null  */
    protected $config = [];

    /** @var string */
    protected string $action = '';

    /** @var string */
    protected string $module = '';

    /** @var string $status */
    protected string $status;

    /** @var string  */
    protected $query;
    protected $city;

    protected $product_id;


    /** @var int  */
    protected int $filterSection;

    /** @var int */
    protected int $page = 1;

    /** @var int */
    protected int $limit = 20;

    /** @var string  */
    public string $notice = '';

    /** @var array */
    public array $errors = [];

    /** @var array */
    public array $messages = [];

    /** @var array */
    public array $response = [];

    /** @var string  */
    public string $buildQueryString = '';

    /** @var array  */
    private array $params = [];

    /** @var Request  */
    public Request $request;

    /** Mnv constructor. */
    public function __construct()
    {
        $this->request = Request::capture();

        $this->config   = Config::init()->config();
        $this->smarty   = Design::init()->design();

        /** модуль */
        $this->module = $this->request->get('mod','');
//        print_r($this->module);
        /** постраничная навигация / по умолчанию страница 1 */
        $dsCookieName = 'limitSelector';
        $dsCookie     = $this->request->cookie($dsCookieName);

        /** action */
        if ($this->request->request->has('action')) {
            $this->action = (string)$this->request->request->get('action', '');
        } else if ($this->request->query->has('action')) {
            $this->action = (string)$this->request->query->get('action', '');
        }

        /** постраничная навигация / по умолчанию страница 1 */
        $this->page   = (int) $this->request->get('page', 1);
        $newLimit     = (int) $this->request->get('limit', '');

        /** фильтрация статей */
        $this->filterSection = (int)$this->request->get('sctn', '');
        $this->query         = $this->request->get('query', '');
        $this->status        = $this->request->get('sts', '');
        $this->city          = $this->request->get('city', '');
        $this->product_id    = $this->request->get('product_id', '');

        if (!empty($dsCookie)) {
            $dsCookie = json_decode($dsCookie, true);
        }

        if (!empty($newLimit)) {
            $this->limit = $newLimit;
            $dsCookie['limit'] = $newLimit;
            Cookie::setcookie($dsCookieName, json_encode($dsCookie), time() + 60*60*24*180);

        } else if (!empty($dsCookie['limit'])) {
            $this->limit = $dsCookie['limit'];
        }

        /** dates */
        $this->smarty->assign('adjustedNow', adjustTime(gmdate('Y-m-d H:i:s')));

        if (!empty($this->query)) {
            $this->params['query'] = $this->query;
        }

        if (!empty($this->filterSection)) {
            $this->params['sctn'] = $this->filterSection;
        }

        if (!empty($this->status)) {
            $this->params['sts'] = $this->status;
        }

        if (!empty($this->city)) {
            $this->params['city'] = $this->city;
        }

        if (!empty($this->product_id)) {
            $this->params['product_id'] = $this->product_id;
        }

        $this->smarty->assign('page', $this->page);
        $this->smarty->assign('limit', $this->limit);
        $this->smarty->assign('sctn', $this->filterSection);
        $this->smarty->assign('sts', $this->status);
        $this->smarty->assign('query', $this->query);
        $this->smarty->assign('city', $this->city);
        $this->smarty->assign('product_id', $this->product_id);


        $this->buildQueryString = !empty($this->params) ? '&' . http_build_query(array_filter($this->params)) : '';
        $this->smarty->assign('buildQueryString', $this->buildQueryString);

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);
        if (!empty($this->action)) $this->smarty->assign('action', $this->action);

//        print_r($_COOKIE);

        $sortTableCol = SortTable::init()->viewSortable($this->module);
//        print_r($sortTableCol);
        $this->smarty->assign('sortOrder', $sortTableCol);

    }

    /**
     * @param array $params
     * @return string|null
     */
    protected function buildQueryString(array $params): ?string
    {
        $result = array_merge($params, $this->params);

        $this->buildQueryString = !empty($result) ? http_build_query(array_filter($result)) : '';

        return $this->buildQueryString;
    }


}