<?php

namespace Mnv\Core\Locale;

/**
 * Class I18N
 * @package Mnv\Core\Locale
 */
final class I18N
{
    /** @var int */
    protected static $index;

    /** @var string  */
    public static $mainLanguage = 'ru';

    /** @var string[]  */
    public static $languages = ['ru', 'uz', 'en'];

    /**
     * @param string|null $websiteLanguage
     */
    public static function set(?string $websiteLanguage)
    {

        self::$mainLanguage = $websiteLanguage;

        if (isset($_SERVER['HTTP_REFERER']) && !empty($_SERVER['HTTP_REFERER'])) {
            $referer = $_SERVER['HTTP_REFERER'];
            $parse_url = parse_url($referer, PHP_URL_PATH);
            $segments = explode('/', $parse_url);

            if (!empty($segments[1]) && in_array($segments[1], self::$languages)) {
                self::$index = $segments[1];
            } else {
                self::$index = self::$mainLanguage;
            }
        } else {
            self::$index = self::$mainLanguage;
        }
    }

    /**
     * @param string|null $ru
     * @param string|null $uz
     * @param string|null $en
     * @return mixed|string
     */
    public static function locale(string $ru, string $uz = null, string $en = null)
    {

        self::$languages = ['ru' => $ru, 'uz' => $uz, 'en' => $en];

        return self::$languages[self::$index];
    }



}