<?php

namespace Mnv\Core\JSONParser\Parser;
/**
 * Определяет интерфейс парсера define parser interface
 *
 * @package JSONParser
 */
interface IParser
{
    public function getCell($row_num, $col, $val_only);
    public function getColumn($col, $val_only);
    public function getRow($row_num, $val_only);
    public function getField($val_only);
    public function isCellExists($row_num, $col);
    public function isColumnExists($col);
    public function isRowExists($row_num);
    public function isFieldExists();
    public function isFileReady($file_path);
    public function loadFile($file_path);
    public function loadString($str);
}