<?php


namespace Mnv\Core\Interfaces;


use Mnv\Http\Request;

/**
 * Class PageNavigation
 * @package Mnv\Core\Interfaces
 */
class PageNavigation
{
    protected $id;
    protected $pages = array();
    protected $currentPage;
    protected $buildQueryString;

    protected $url;

    /** @var  Request */
    protected $request;

    public function __construct($pages)
    {
        $this->pages = $pages;
    }

    /**
     * @param string $url URL текущей страницы
     * @return $this
     */
    public function setUrl($url)
    {
        $this->url = $url;

        return $this;
    }

    /**
     * @param int $n Номер текущей страницы.
     * @return $this
     */
    public function setCurrentPage(int $n)
    {
        $this->currentPage = $n;

        return $this;
    }

    /**
     * Возвращает номер текущей страницы.
     * @return int
     */
    public function getCurrentPage()
    {
        return $this->currentPage ?? 1;
    }

    /**
     * @param string $buildQueryString Query параметры текущей страницы
     * @return $this
     */
    public function setQueryString($buildQueryString)
    {
        $this->buildQueryString = $buildQueryString;
        return $this;
    }

   public function getQueryString()
   {
       return $this->buildQueryString;
   }


    public function pagination()
    {
        $pagination = '<div class="card-footer d-sm-flex justify-content-sm-between align-items-sm-center">';
        $pagination .= $this->results();
        if (!empty($this->pages) && isset($this->pages['pages']) && $this->pages['pages'] > 0) {
            $pagination .= $this->pages();
        }
        $pagination .= '</div>';

        return $pagination;
    }

    /** Результаты */
    private function results()
    {
        $result = '<div class="text-muted">Результаты ';
        if (isset($this->pages['startIteration'])) {
            $result .= 'с <b>' . $this->pages['startIteration'] .'</b> по <b>' . $this->pages['endIteration'] . '</b> из <b>' . $this->pages['totalItems'] . '</b>';
        } else {
            $result .= '<b>0</b>';
        }

        $result .= '</div>';

        return $result;
    }

    private function previousPage()
    {
        $previousPage = '';

        if (isset($this->pages['previousPage'])) {
            $previousPage .= '<li class="page-item" disabled="">';
            $previousPage .= '<a class="page-link rounded" href="' . $this->url . '?page=' . $this->pages['previousPage'] . $this->buildQueryString . '">←</a>';
            $previousPage .= '</li>';

            return $previousPage;
        }
    }

    private function nextPage()
    {
        $nextPage = '';
        if (isset($this->pages['nextPage'])) {
            $nextPage .= '<li class="page-item" disabled="">';
            $nextPage .= '<a  class="page-link rounded" href="' . $this->url . '?page=' . $this->pages['nextPage'] . $this->buildQueryString .'" >→</a>';
            $nextPage .= '</li>';
		}

        return $nextPage;
    }

    private function pages()
    {
        $pagination = '<ul class="pagination pagination-spaced pagination-sm">';
        $pagination .= $this->previousPage();

        foreach ($this->pages['pages'] as $number) {
            if ($number == $this->currentPage) {
                $pagination .= '<li class="page-item active"><a class="page-link rounded" href="' . $this->url . '?page=' . $number . $this->buildQueryString. '">' . $number .'</a></li>';
            } elseif ($number == '...') {
                $pagination .= '<li class="page-item"><a class="page-link rounded">...</a></li>';
            }else {
                $pagination .= '<li class="page-item"><a class="page-link rounded" href="' . $this->url . '?page=' . $number . $this->buildQueryString .'">' . $number .'</a></li>';
            }
        }

        $pagination .= $this->nextPage();

        $pagination .= '</ul>';

        return $pagination;
    }
}