
	<!-- Page header -->
	{capture name="buttons"}
		<a class="btn btn-sm btn-primary mx-1" data-bs-popup="tooltip" title="{general:add}" data-bs-placement="auto" href="{$adminUrl}/client?action=add{if !empty($page)}&page={$page}{/if}{$buildQueryString}"><i class="icon-plus3"></i></a>
	{/capture}
	{capture name="breadcrumb"}
		<a href="{$adminUrl}/clients" class="breadcrumb-item">{if isset($title)}{$title}{/if}</a>
	{/capture}

	{capture name="showBy"}
	    {include file="module/show-by.tpl" url="{$adminUrl}/clients"}
	{/capture}

	{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

	<!-- Content area -->
	<div class="content">

	    <div class="row">
	        <div class="col-md-12">

	            <div class="card">

		            <div class="">
	                    <table class="table table-togglable table-striped table-hover users-archive" id="clients">
		                    <thead>
		                        <tr>
		                            <th class="text-center" width="30">{users:table:id}</th>
		                            <th class="text-start" width="30">Ф.И.О.</th>
		                            <th class="">Telegram</th>
		                            <th class="">{users:table:phone}</th>
		                            <th >{users:table:email}</th>
			                        <th class="text-center">ТИП</th>
		                            <th class="text-center text-muted"width="30"><i class="ph-check"></i></th>
		                        </tr>
		                    </thead>
		                    {if !empty($users)}
		                    <tbody>
		                        {foreach item=user from=$users name=users}
		                        <tr id="client-{$user.userId}">
		                            <td class="text-center text-nowrap">{$user.userId}</td>
		                            <td class="text-start text-nowrap">{$user.fullName nofilter}</td>
		                            <td class="text-start">{$user.telegram}</td>
		                            <td class="text-start">{$user.phone nofilter}</td>
		                            <td class="text-start">{$user.email}</td>
		                            <td class="text-center">{$user.userType}</td>
		                            <td class="text-center">
		                                <div class="d-inline-flex">
			                                <a class="text-primary" data-bs-popup="tooltip" title="{general:edit}" data-bs-placement="auto" href="{$adminUrl}/client?action=edit&id={$user.userId}{if !empty($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-note-pencil me-2"></i></a>
		                                    <div class="dropdown">
			                                    <a class="text-body" data-bs-toggle="dropdown"><i class="ph-list"></i></a>

		                                        <div class="dropdown-menu dropdown-menu-end">
		                                            <a class="dropdown-item" href="{$adminUrl}/client?action=edit&id={$user.userId}&page={$page}{$buildQueryString}"><i class="ph-note-pencil me-2"></i> {general:edit}</a>
		                                            <div class="dropdown-divider"></div>
		                                            <button class="dropdown-item text-danger" type="button" onclick="newRemove({$user.userId}, '{$user.email|escape}', 'clients')"><i class="ph-trash me-2"></i> {general:delete}</button>
		                                        </div>
		                                    </div>
		                                </div>
		                            </td>
		                        </tr>
		                        {/foreach}

		                    </tbody>
		                    {else}
		                        <tbody><tr class="odd"><td class="text-center" colspan="6">- {general:none} -</td></tr></tbody>
		                    {/if}
		                </table>
		            </div>

	                {include file="module/pagination.tpl" url="{$adminUrl}/clients" params="{$buildQueryString}"}

	            </div>
	        </div>

	    </div>
	</div>

	<script>

	    function deleteImageMessage(){ new Noty({ text: '{users:messages:2}', type: 'success', timeout: 1500 }).show(); }
	    function deleteMessage(){ new Noty({  text: '{users:messages:1}', type: 'success', timeout: 1500 }).show(); }
	    function userNotFound(){ new Noty({ text: '{managers:errors:1}', type: 'error' }).show(); }
	    function notDeleteAdministrator(){ new Noty({ text: '{managers:errors:6}', type: 'error' }).show(); }
	    function notDeleteDeveloper(){ new Noty({ text: '{managers:errors:14}', type: 'error' }).show(); }
	    function notDeleteFound(){ new Noty({ text: '{users:errors:17}', type: 'error' }).show(); }


	</script>




