<form method="post" id="order">

	<!-- Page header -->
    {capture name="buttons"}
	    <button class="btn btn-sm btn-primary" type="submit" name="action" value="save"><i class="ph-floppy-disk me-2"></i>Сохранить заказ</button>
	    <button class="btn btn-sm btn-primary mx-2" type="submit" name="action" value="apply"><i class="ph-check me-2"></i> {general:apply}</button>
	    <a class="btn btn-sm btn-primary legitRipple" href="{$adminUrl}/orders">Вернуться к назад</a>
    {/capture}

    {capture name="breadcrumb"}
		<a href="{$adminUrl}/orders" class="breadcrumb-item">{$title}</a>
    {/capture}

    {capture name="showBy"}
    {/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

    <div class="content">
	    <div class="card border shadow-sm">
		    <div class="card-header justify-content-between m-0 p-0">
			    <ul class="nav nav-tabs nav-tabs-overline nav-justified">

				    <li class="nav-item"><a class="nav-link active show" href="#tab-client" data-bs-toggle="tab">Клиент</a></li>
				    <li class="nav-item"><a class="nav-link" href="#tab-carts" data-bs-toggle="tab">Товары </a></li>
				    <li class="nav-item"><a class="nav-link" href="#tab-shipping" data-bs-toggle="tab">Доставка</a></li>
				    <li class="nav-item"><a class="nav-link" href="#tab-total" data-bs-toggle="tab">Итого</a></li>
			    </ul>
		    </div>

		    <div class="card-body m-0 p-0">
			    <div class="tab-content mb-0 p-3">
				    <div class="tab-pane fade show active" id="tab-client">
					    <fieldset class="">
						    <div class="row mb-3">
							    <label class="col-lg-3 col-form-label text-lg-end">Ф.И.О.: <span class="text-danger">*</span></label>
							    <div class="col-lg-9">
								    <input type="text" class="form-control" name="order[fullName]" value="{$order.fullName|default:''}" placeholder="Ф.И.О.">
							    </div>
						    </div>

						    <div class="row mb-3">
							    <label class="col-lg-3 col-form-label text-lg-end">Имя: <span class="text-danger">*</span>  </label>
							    <div class="col-lg-9">
								    <input type="text" class="form-control" name="order[firstName]" value="{$order.firstName|default:''}" placeholder="Имя">
							    </div>
						    </div>

						    <div class="row mb-3">
							    <label class="col-lg-3 col-form-label text-lg-end">Фамилия: <span class="text-danger">*</span></label>
							    <div class="col-lg-9">
								    <input type="text" class="form-control" name="order[lastName]" value="{$order.lastName|default:''}" placeholder="Фамилия">
							    </div>
						    </div>

						    <div class="row mb-3">
							    <label class="col-lg-3 col-form-label text-lg-end">E-Mail: <span class="text-danger">*</span></label>
							    <div class="col-lg-9">
								    <input type="email" class="form-control" name="order[email]" value="{$order.email|default:''}" placeholder="email@domain.com">
							    </div>
						    </div>
						    <div class="row mb-3">
							    <label class="col-lg-3 col-form-label text-lg-end">Телефон: <span class="text-danger">*</span></label>
							    <div class="col-lg-9">
								    <input type="tel" class="form-control" name="order[phone]" value="{$order.phone|default:''}" placeholder="Введите номер телефона">
							    </div>
						    </div>
{*						    <div class="row mb-3">*}
{*							    <label class="col-lg-3 col-form-label text-lg-end">Адрес:</label>*}
{*							    <div class="col-lg-9">*}
{*								    <input type="text" class="form-control" name="order[address]" value="{$order.address|default:''}" placeholder="Адрес">*}
{*							    </div>*}
{*						    </div>*}
					    </fieldset>
				    </div>

				    <div class="tab-pane fade" id="tab-carts">
					    <table class="table table-xs table-togglable table-striped table-hover mb-4">
						    <thead>
						    <tr>
							    <th class="text-start">Наименование товара</th>
							    <th class="text-start">Артикул</th>
							    <th class="text-center" width="200">Кол-во</th>
							    <th class="text-end">Цена за единицу</th>
							    <th class="text-end">Итого</th>
{*							    <th class="text-end" width="30"></th>*}
						    </tr>
						    </thead>
						    <tbody id="cart">
                            {assign var=product_row value=0}
                            {if !empty($order.products)}
                            {foreach from=$order.products item=product}
							    <tr id="product">
								    <td class="text-start">
									    <a href="product?action=edit&id={$product.product_id}" target="_blank">{$product.name}</a>
									    <input type="hidden" name="product[{$product_row}][product_id]" value="{$product.product_id}">
									    <ul class="list list-unstyled mb-0 text-muted fs-sm">
                                            {foreach from=$product.option item=option}
											    <li>- {$option.name}: {$option.value}</li>
	                                            <input type="hidden" name="product[{$product_row}][option][{$option.product_option_id}]" value="{$option.product_option_value_id}">
                                            {/foreach}
									    </ul>
								    </td>

								    <td class="text-start">{$product.sku}</td>
								    <td class="text-center">
									    <input class="form-control form-control-number text-center" type="hidden" name="product[{$product_row}][product_id]" value="{$product.product_id}">
									    <div class="input-group">
										    <button type="button" class="btn btn-light btn-icon btn-product minus" {if $product.quantity eq 1}disabled{/if} onclick="minus(this)"><i class="ph-minus ph-sm"></i></button>
										    <input class="form-control form-control-number text-center" type="number" name="product[{$product_row}][quantity]" value="{$product.quantity}" min="0">
										    <button type="button" class="btn btn-light btn-icon btn-product plus" onclick="plus(this)"><i class="ph-plus ph-sm"></i></button>
									    </div>
								    </td>
								    <td class="text-end">{$product.price|number_format:0:".":" "} сум</td>
								    <td class="text-end">{$product.total|number_format:0:".":" "} сум</td>
{*								    <td><button type="button" value="{$product.product_id}" class="btn btn-sm btn-danger btn-remove-product"><i class="ph-trash"></i></button></td>*}
							    </tr>
                                {assign var=product_row value=$product_row+1}
                            {/foreach}
						    {/if}

						    </tbody>
					    </table>
{*					    <div class="mb-4">*}
{*						    <div class="fw-bold border-bottom pb-2 mb-4">Добавить товар</div>*}

{*						    <div class="row mb-3">*}
{*							    <label class="col-form-label col-lg-3">Выберите товар</label>*}
{*							    <div class="col-lg-9">*}
{*								    <input type="text" class="form-control" data-bs-popup="tooltip" data-bs-trigger="focus" placeholder="Click on input" aria-label="Tooltip on focus" data-bs-original-title="Tooltip on focus">*}
{*							    </div>*}
{*						    </div>*}

{*						    <div class="row mb-3">*}
{*							    <label class="col-form-label col-lg-3">Количество</label>*}
{*							    <div class="col-lg-9">*}
{*								    <input type="text" class="form-control" name="">*}
{*							    </div>*}
{*						    </div>*}
{*					    </div>*}
				    </div>

				    <div class="tab-pane fade" id="tab-shipping">
					    <fieldset class="">
{*						    <div class="row mb-3">*}
{*							    <label class="col-lg-3 col-form-label text-lg-end">Ф.И.О.: <span class="text-danger">*</span></label>*}
{*							    <div class="col-lg-9">*}
{*								    <input type="text" class="form-control" name="order[fullName]" value="{$order.fullName|default:''}" placeholder="Ф.И.О." readonly>*}
{*							    </div>*}
{*						    </div>*}

{*						    <div class="row mb-3">*}
{*							    <label class="col-lg-3 col-form-label text-lg-end">Имя: <span class="text-danger">*</span>  </label>*}
{*							    <div class="col-lg-9">*}
{*								    <input type="text" class="form-control" name="order[firstName]" value="{$order.firstName|default:''}" placeholder="Имя" readonly>*}
{*							    </div>*}
{*						    </div>*}

{*						    <div class="row mb-3">*}
{*							    <label class="col-lg-3 col-form-label text-lg-end">Фамилия: <span class="text-danger">*</span></label>*}
{*							    <div class="col-lg-9">*}
{*								    <input type="text" class="form-control" name="order[lastName]" value="{$order.lastName|default:''}" placeholder="Фамилия" readonly>*}
{*							    </div>*}
{*						    </div>*}
						    <div class="row mb-3">
							    <label class="col-lg-3 col-form-label text-lg-end">Адрес:</label>
							    <div class="col-lg-9">
								    <input type="text" class="form-control" name="order[address]" value="{$order.address|default:''}" placeholder="Адрес">
							    </div>
						    </div>
						    <div class="row mb-3">
							    <label class="col-lg-3 col-form-label text-lg-end">Город:</label>
							    <div class="col-lg-9">
								    <input type="text" class="form-control" name="order[shipping_zone]" value="{$order.shipping_zone|default:''}" placeholder="Адрес">
							    </div>
						    </div>
{*						    <div class="row mb-3">*}
{*							    <label class="col-lg-3 col-form-label text-lg-end">Район:</label>*}
{*							    <div class="col-lg-9">*}
{*								    <input type="text" class="form-control" name="order[district]" value="{$order.district|default:''}" placeholder="Адрес">*}
{*							    </div>*}
{*						    </div>*}
{*						    <div class="row mb-3">*}
{*							    <label class="col-lg-3 col-form-label text-lg-end">Улица:</label>*}
{*							    <div class="col-lg-9">*}
{*								    <input type="text" class="form-control" name="order[street]" value="{$order.street|default:''}" placeholder="Адрес">*}
{*							    </div>*}
{*						    </div>*}
{*						    <div class="row mb-3">*}
{*							    <label class="col-lg-3 col-form-label text-lg-end">Дом:</label>*}
{*							    <div class="col-lg-9">*}
{*								    <input type="text" class="form-control" name="order[house]" value="{$order.house|default:''}" placeholder="Адрес">*}
{*							    </div>*}
{*						    </div>*}
					    </fieldset>
				    </div>

				    <div class="tab-pane fade" id="tab-total">
                        {if !empty($order.products)}
					    <fieldset class="">
						    <table class="table table-xs table-bordered mb-4">
							    <thead>
								    <tr>
									    <th class="text-start">Наименование товара</th>
									    <th class="text-start">Артикул</th>
									    <th class="text-center" width="200">Кол-во</th>
									    <th class="text-end">Цена за единицу</th>
									    <th class="text-end">Итого</th>
								    </tr>
							    </thead>
							    <tbody>
	                                {foreach from=$order.products item=product}
									    <tr>
										    <td class="text-start">
											    <a href="product?action=edit&id={$product.product_id}" target="_blank">{$product.name}</a>
											    <ul class="list list-unstyled mb-0 text-muted fs-sm">
                                                {foreach from=$product.option item=option}
												    <li>- {$option.name}: {$option.value}</li>
                                                {/foreach}
											    </ul>
										    </td>

										    <td class="text-start">{$product.sku}</td>
										    <td class="text-end">{$product.quantity}</td>
										    <td class="text-end">{$product.price|number_format:0:".":" "} сум</td>
										    <td class="text-end">{$product.total|number_format:0:".":" "} сум</td>
									    </tr>
	                                {/foreach}
                                    {foreach from=$order.totals item=total}
	                                <tr>
		                                <td class="text-end" colspan="4">{$total.title}:</td>
		                                <td class="text-end">{$total.value|number_format:0:".":" "} сум</td>
	                                </tr>
                                    {/foreach}
							    </tbody>
						    </table>
					    </fieldset>
                        {/if}
					    <fieldset class="">
						    <div class="fw-bold border-bottom pb-2 mb-4">Заказ</div>
{*						    <div class="row mb-3">*}
{*							    <label class="col-lg-3 col-form-label text-lg-end">Способ доставки: <span class="text-danger">*</span></label>*}
{*							    <div class="col-lg-9">*}
{*								    <input type="text" class="form-control" name="order[fullName]" value="{$order.fullName|default:''}" placeholder="Ф.И.О.">*}
{*							    </div>*}
{*						    </div>*}

						    <div class="row mb-3">
							    <label class="col-lg-3 col-form-label text-lg-end">Способ оплаты: <span class="text-danger">*</span>  </label>
							    <div class="col-lg-9">
								    <select  name="order[payment_method]" id="payment_method" class="form-control select">
									    <option value="click" {if $order.payment_method|lower eq 'click'}selected="selected"{/if}>Click</option>
									    <option value="payme" {if $order.payment_method|lower eq 'payme'}selected="selected"{/if}>Payme</option>
									    <option value="uzum" {if $order.payment_method|lower eq 'uzum'}selected="selected"{/if}>Uzum</option>
									    <option value="cash" {if $order.payment_method|lower eq 'cash'}selected="selected"{/if}>Наличные</option>
								    </select>
							    </div>
						    </div>

						    <div class="row mb-3">
							    <label class="col-lg-3 col-form-label text-lg-end">Статус заказа: <span class="text-danger">*</span></label>
							    <div class="col-lg-9">

                                    {html_options options=$order_statuses name="order[order_status_id]" id="order_statuses" selected=$order.order_status_id class="form-control select"}
							    </div>
						    </div>

						    <div class="row mb-3">
							    <label class="col-lg-3 col-form-label text-lg-end">Комментарий: <span class="text-danger">*</span></label>
							    <div class="col-lg-9">
								    <textarea rows="3" cols="3" class="form-control" placeholder="Enter your text" readonly="">{$order.message|default:''}</textarea>
							    </div>
						    </div>
					    </fieldset>
				    </div>

			    </div>
		    </div>
	    </div>
	    <div class="text-center mt-3 mb-3">
            {if isset($order.order_id)}<input type="hidden" class="form-control" id="id" name="id" value="{$order.order_id}">{/if}
            {$smarty.capture.buttons nofilter}
	    </div>
    </div>


</form>
<script>
	$(document).ready(function () {
		{if isset($messages.saved)} new Noty({ text: '{orders:messages:0}', type: 'success', timeout: 1500 }).show(); {/if}
        {if isset($errors.not_saved)} new Noty({ text: '{products:errors:3}',  type: 'error', timeout: 2500 }).show();     {/if}
	});
        
	function deleteMessage(){
	    new Noty({ text: '{orders:messages:1}', type: 'success', timeout: 1500 }).show();
	}

	function minus($this) {
        if ($this.parentNode.querySelector('input[type=number]').value == 1) {
            $this.parentNode.querySelector('.minus').disabled = true;
        }
        if ($this.parentNode.querySelector('input[type=number]').value > 1) {
            $this.parentNode.querySelector('input[type=number]').stepDown();
        }
    }

    function plus($this) {
	    console.log($this.parentNode.querySelector('input[type=number]').value)
        if ($this.parentNode.querySelector('input[type=number]').value > 0) {
            $this.parentNode.querySelector('.minus').disabled = false;
        }
        $this.parentNode.querySelector('input[type=number]').stepUp()
    }


    $('#cart').delegate('.btn-product', 'click', function() {
        var node = this;

        // Refresh products, vouchers and totals
        $.ajax({
            url: 'index.php?mod=order&action=edit_product&id={$order.order_id|default:0}',
            type: 'post',
            data: $('#cart input[name^=\'product\'][type=\'text\'], #cart input[name^=\'product\'][type=\'number\'], #cart input[name^=\'product\'][type=\'hidden\'], #cart input[name^=\'product\'][type=\'radio\']:checked, #cart input[name^=\'product\'][type=\'checkbox\']:checked, #cart select[name^=\'product\'], #cart textarea[name^=\'product\']'),
            dataType: 'json',
            crossDomain: true,
            beforeSend: function() {
                $(node).button('loading');
            },
            complete: function() {
                $(node).button('reset');
            },
            success: function(json) {
                if (json.status == 200) {
                    new Noty({ text: json.message, type: json.type, timeout: 1500 }).show();
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
               // alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
            }
        }).done(function() {
            // $('#button-refresh').trigger('click');
        });
    });

    $('#cart').delegate('.btn-remove-product', 'click', function() {
        var node = this;

        $.ajax({
            url: 'index.php?mod=order&action=remove_product&id={$order.order_id|default:0}',
            type: 'post',
            data: 'product_id=' + encodeURIComponent(this.value),
            dataType: 'json',
            crossDomain: true,
            beforeSend: function() {
                $(node).button('loading');
            },
            complete: function() {
                $(node).button('reset');
            },
            success: function(json) {
                $('.alert-dismissible, .text-danger').remove();

                // Check for errors
                if (json['error']) {
                    $('#content > .container-fluid').prepend('<div class="alert alert-danger alert-dismissible"><i class="fa fa-exclamation-circle"></i> ' + json['error'] + ' <button type="button" class="close" data-dismiss="alert">&times;</button></div>');
                } else {
                    // Refresh products, vouchers and totals
                    $('#button-refresh').trigger('click');
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
            }
        });
    });
</script>