
<!-- Page header -->
{capture name="buttons"}
    {if !empty($sections)}
		<a class="btn btn-sm btn-primary" data-bs-popup="tooltip" title="{general:add}" data-bs-placement="auto" href="{$generate_url|substr:0:-1}?action=edit{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="icon-plus3"></i></a>
    {/if}
{/capture}

{capture name="breadcrumb"}
	<a href="{$generate_url}" class="breadcrumb-item">{$title}</a>
{/capture}

{capture name="showBy"}
    {include file="module/show-by.tpl" url=$generate_url}
{/capture}

{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
<!-- /page header -->

<!-- Content area -->
<div class="content">

	<div class="row">
		<div class="col-md-12">
            {if empty($sections)}
				<div class="card border shadow-sm">
					<div class="alert bg-danger text-white alert-dismissible m-0">
						<span class="font-weight-semibold">Перед добавлением, добавьте хотя бы один <a href="{$adminUrl}/section?action=add&parentId=0" class="text-white">раздел</a>.</span>
					</div>
				</div>
            {/if}

			<div class="card border shadow-sm">
                <form action="{$generate_url}" method="post">
                    <div class="card-header bg-light py-2 d-sm-flex align-items-sm-center">
                        <div class="mb-0">
                            <div class="input-group">
                                <input type="text" class="form-control" name="query" value="{if isset($query)}{$query}{/if}" autocomplete="off" placeholder="{products:general:searchByName}">
                                <button type="submit" class="btn btn-sm btn-primary"><i class="icon-search4 me-2"></i>{general:search}</button>
                            </div>
                        </div>

                        <div class="ms-sm-auto">
                            <ul class="list-inline list-inline-condensed mb-0">
                                <li class="list-inline-item">
                                    <div class="input-group">
                                        {if isset($sections) && !empty($sections)}
                                            {html_options options=$sections selected=$sctn|default:'' name="sctn" class="form-control select" onchange="this.form.submit()" data-width="250"}
                                        {/if}

                                        {if isset($countries) && !empty($countries)}
                                            {html_options options=$countries selected=$city|default:'' name="city" class="form-control select" onchange="this.form.submit()" data-width="160"}
                                        {/if}

                                        {if isset($statuses) && !empty($statuses)}
                                            {html_options options=$statuses selected=$sts|default:'' name="sts" class="form-control select" onchange="this.form.submit()" data-width="160"}
                                        {/if}

                                    </div>
                                    <button class="btn btn-sm btn-primary daterange-btn" type="submit" style="display: none">{stats:show}</button>
                                </li>
                            </ul>
                        </div>
                    </div>
                </form>
			</div>

			<div class="card card_check_button collapse">
				<div class="card-header bg-light py-2 header-elements-sm-inline">
					<div class="header-elements">
						<ul class="list-inline list-inline-condensed mb-0">
							<button class="btn btn-sm btn-primary" type="button">Удалить выбранное</button>
						</ul>
					</div>
				</div>
			</div>

			<div class="card border shadow-sm">
				<div class="card-header d-flex flex-wrap">
					<div class="mb-0">
						<a href="{$generate_url|substr:0:-1}?action=edit{if isset($page)}&page={$page}{/if}{$buildQueryString}" class="btn btn-sm btn-primary" title="{general:add}"><i class="ph-plus me-2"></i>{general:add}</a>
					</div>
				</div>

				<div class="">
					<table class="table table-xs table-togglable table-striped table-hover" id="{$module}">
						<thead>
						<tr>
							<th class="text-center" width="30">
								<div class="form-check">
									<input type="checkbox" class="form-check-input content_check_all">
								</div>
							</th>
							<th class="text-center" width="80">{general:table:date}</th>
							<th class="text-center" width="120">{general:table:image}</th>
							<th class="text-start">{general:table:name}</th>
							<th class="text-center">Город</th>
							<th class="text-center">{general:table:section}</th>
							<th class="text-center text-muted" width="30"><i class="ph-check"></i></th>
						</tr>
						</thead>
                        {if !empty($articles)}
							<tbody>
                            {foreach item=article from=$articles name=articles}
								<tr id="{$module|substr:0:-1}-{$article.stationId}" data-id="{$article.stationId}" class="{if $article.status eq 'H'}table-danger{/if}{if $article.status eq 'P'}table-warning{/if}">
									<td class="text-center">
										<div class="form-check">
											<input type="checkbox" class="form-check-input content_list_check" value="{$article.stationId}" data-id="{$article.stationId}">
										</div>
									</td>
									<td class="text-left text-nowrap"><span>{$article.publishedOn|date_format:$config.date_format_custom}</span></td>
									<td class="text-center"><div class="preview preview-md"><img src="{$article.image}" class="img-thumbnail w-80px" alt="{$article.title}"/></div></td>
									<td class="text-start"><b data-bs-popup="tooltip" title="{$article.title}" data-bs-placement="auto">{$article.title|truncate:75}</b></td>
									<td class="text-center">{$article.country|truncate:25}</td>
									<td class="text-center">{$article.section|truncate:25}</td>
									<td class="text-center">
										<div class="d-inline-flex">
											<a class="text-primary" data-bs-popup="tooltip" title="{general:edit}" data-bs-placement="auto" href="{$generate_url|substr:0:-1}?action=edit&id={$article.stationId}{if !empty($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-note-pencil me-2"></i></a>
											<div class="dropdown">
												<a class="text-body" data-bs-toggle="dropdown"><i class="ph-list"></i></a>
												<div class="dropdown-menu dropdown-menu-end">
                                                    {if $article.status eq 'P'}
														<button class="dropdown-item text-danger" id="article-approve-{$article.stationId}" onclick="return approve({$article.stationId}, '{$module}');"><i class="icon-thumbs-up2 me-2"></i> {general:approve}</button>
                                                    {/if}
													<a class="dropdown-item" href="{$article.url}" target="_blank"><i class="ph-share me-2"></i> {general:view}</a>
													<button class="dropdown-item"><i class="ph-star me-2 {if $article.isFeatured}text-warning{/if}"></i> {general:table:favorites}</button>
													<a class="dropdown-item" href="{$generate_url|substr:0:-1}?action=edit&id={$article.stationId}{if !empty($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-note-pencil me-2"></i> {general:edit}</a>
													<button class="dropdown-item ajax_action" data-module="articles" data-action="status" data-id="{$article.stationId}"><i class="{if $article.status eq 'V'}ph-eye{else}ph-eye-slash{/if} me-2"></i> {general:status}</button>
													<div class="dropdown-divider"></div>
													<button class="dropdown-item text-danger" onclick="newRemove({$article.stationId}, '{$article.title|escape}', '{$module}');"><i class="ph-trash me-2"></i> {general:delete}</button>
												</div>
											</div>
										</div>
									</td>
								</tr>
                            {/foreach}
							</tbody>
                        {else}
							<tbody><tr class="odd"><td class="text-center" colspan="8">- {general:none} -</td></tr></tbody>
                        {/if}
					</table>
				</div>
                {include file="module/pagination.tpl" url="{$generate_url}" params="{$buildQueryString}"}
			</div>
		</div>

	</div>
</div>

<script>

    function notFound() {
        new Noty({ text: 'контент не найден или пустой ID', layout: 'topRight', type: 'error', timeout: 1500 }).show();
    }
    function approveError() {
        new Noty({ text: 'ошибка при одобрение контента', layout: 'topRight', type: 'error', timeout: 2500 }).show();
    }

    function approveSuccess(id) {
        document.getElementById('status-' + id).innerHTML = '{general:statuses:V}';
        document.getElementById('article-approve-' + id).style.display = 'none';
        document.getElementById('article-status-' + id).innerHTML = '<i class="icon-eye"></i> {general:statuses:V}';
        new Noty({ text: 'Контент одобрен без модерации', layout: 'topRight', type: 'success', timeout: 1500 }).show();
    }

    $(document).ready(function () {

        {if isset($messages.saved)} new Noty({ text: '{articles:messages:0}', type: 'success', timeout: 1500 }).show(); {/if}

        {if isset($errors.access_denied)} new Noty({ text: '{articles:errors:0}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.not_saved)}   new Noty({ text: '{articles:errors:3}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.no_sections)} new Noty({ text: '{articles:errors:4}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.article_not_found)} new Noty({ text: '{articles:errors:6}', type: 'error', timeout: 2500 }).show(); {/if}

        {if isset($notice)} new Noty({ text: {$notice}, type: 'error', timeout: 2500 }).show(); {/if}

    });


    // выбрать все
    $(document).on("change", ".content_check_all", function () {
        if ($(this).is(":checked")) {
            $('.content_list_check').each(function () {
                if (!$(this).is(":checked")) $(this).trigger("click");
            });
            $('.footer_navbar').removeClass('collapse').addClass('fixed-bottom')
        } else {
            $('.content_list_check').each(function () {
                if ($(this).is(":checked")) $(this).trigger("click");
            });
            $('.footer_navbar').addClass('collapse').removeClass('fixed-bottom')
        }
    });

    // выбрать один
    $(document).on("change", ".content_list_check", function () {
        if ( $('input.content_list_check:checked').length > 0 ) {
            $('.footer_navbar').removeClass('collapse').addClass('fixed-bottom')

        } else {
            $('.footer_navbar').addClass('collapse').removeClass('fixed-bottom')
            if ($('.content_check_all').is(":checked")) $('.content_check_all').trigger("click");
            // $('.content_check_all').trigger("click");
        }
    });

    $(document).on('click', '.content_save_button',  function () {
        var stationIds = [];
        $('.content_list_check').each(function () {
            if ($(this).is(":checked")) {
                stationIds.push($(this).attr("data-id"));
            }
        });

        var group_action_text =  $(".content_select_action :selected").text();
        var group_action =  $(".content_select_action").val();

        bootbox.confirm({
            closeButton: false,
            message: 'Вы действительно хотите "' + group_action_text + '"?' ,
            callback: function(result) {
                console.log(result);
                if (result === true) {
                    $.post('index.php?mod={$module}&action=group', { stationIds: stationIds, group_action: group_action }, function (data) {
                        console.log(data);
                        new Noty({ text: data.message, type: data.type }).show();
                        if (data.status === 200) {
                            setTimeout(function() {
                                window.location.reload();
                            }, 1500);

                        }
                    }, 'json');
                }
            }
        });
    });


</script>




