<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;

use Mnv\Models\Feedbacks;

/**
 * Class FeedbacksAdmin
 * @package Mnv\Admin\Controllers
 */
class FeedbacksAdmin extends AdminMnv
{

    public function fetch()
    {

        $dateSelector = new StatsDateSelector(false, 'feedbackDateSelector');

        $feedback = new Feedbacks($this->request);

        $this->smarty->assign('activeItem','feedbacks');
        $this->smarty->assign('title', 'Центр сообщений');

        /** statuses */
        $collection = collect(['0' => 'Выберите статус']);
        $statuses = $collection->merge(array_slice(lang('comments:statuses'), 1))->all();
        $this->smarty->assign('statuses', $statuses);

        if ($this->action == 'remove') {
            $result = $feedback->remove()
                ? array('status' => 200, 'message' => 'Письмо удалено ', 'type' => 'success')
                : array('status' => 403, 'message' => 'Письмо Не удалено ', 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        else if ($this->action == 'change_status') {
            $result = $feedback->status()
                ? array('status' => 200, 'message' => lang('general:restatus'), 'type' => 'success')
                : array('status' => 500, 'message' => 'Error when changing the status', 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit;

        }

        /** фильтровать контента */
        $feedback->filter = array_filter([
            'dateStart'     => $dateSelector->dateStart,
            'dateEnd'       => $dateSelector->dateEnd,
            'status'        => $this->status,
            'query'         => $this->query,
        ]);

        $feedbacks = collect($feedback->all($this->limit, $this->page))->map(function ($item) {
            $item['statusName'] = lang('comments:statuses:'.$item['status']);
            $item['created'] =  langDate(adjustTime($item['created'], false, 'd.m.Y H:i'));

            return $item;
        })->all();


        $feedback->total();
        $pages = getPageNums($feedback->total, $this->page, $this->limit, 0, 4, 4, 0 );

        $this->smarty->assign( 'totalFeedback', $feedback->total);
        $this->smarty->assign( 'feedbacks', $feedbacks);
        $this->smarty->assign( 'pageNums', $pages);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if ($this->permissions('feedbacks')) {
            return $this->smarty->fetch('views/feedbacks/feedbacks.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }

}