<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Test\Logger;

use Mnv\Models\Brands;

/**
 * Class BrandsAdmin
 * @package Mnv\Admin\Controllers
 */
class BrandsAdmin extends AdminMnv
{

    public function fetch()
    {
        $brand = new Brands($this->request);

        $this->smarty->assign('title', lang('brands:title'));
        $this->smarty->assign('activeItem', 'brands');

         if ($this->action == 'remove') {

             if ($brand->remove()) {
                 Logger::init()->info("Бранд с «ID-" . $brand->id . "» удален.", $this->manager['userId'])->save();
                 $result = array('status' => 200, 'message' => lang('brands:messages:2'), 'type' => 'success');
             } else {
                 $result = array('status' => 403, 'message' => lang('brands:errors:11'), 'type' => 'error');
             }
             response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
             exit();

        }
         else if ($this->action == 'approve') {

            if ($brand->approve()) {
                response()->make("document.getElementById('status-$brand->id ').innerHTML = 'Включено';", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }

        }
        // не делал еще
//        else if ($this->action == 'reorder') {
//
//            $ids = array_values($this->brandIds);
//            sort($this->brandIds);
//            //$this->brandIds = array_reverse($this->brandIds);
//            $this->reorderBrand($ids, $this->brandIds, 'brandId', $this->brandId);
//
//        }
        else if ($this->action == 'status') {

            $result = $brand->status()
                ? array('data' => true, 'status' => $brand->status, 'type' => 'success')
                : array('data' => false, 'status' => $brand->status, 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT)->send();
            exit();

        } else {

            $brand->filter = array_filter([
                'status'        => $this->status,
                'query'         => $this->query,
            ]);
            /** получение всех статей */
            $brands = collect($brand->all( $this->limit, $this->page))->map(function ($item) use ($brand) {
                $item['statusName']  = lang('general:statuses:' . $item['status']);
                $image                  = $brand->getMainImage($item['brandId']);
                $item['image']          = !empty($image['original']) ? $image['original'] : '/admin/assets/img/no_images.jpg';

                return $item;
            })->all();


            /** pagination */
            $brand->total();
            $pages = getPageNums($brand->total, $this->page, $this->limit, 0, 4, 4, 0);

            /** вывод в шаблон результатов */
            $this->smarty->assign('totalBrands', $brand->total);
            $this->smarty->assign('brands', $brands);
            $this->smarty->assign('pageNums', $pages);
            $this->smarty->assign('page', $this->page);

        }

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if ($this->permissions('brands')) {
            return $this->smarty->fetch('views/brands/brands.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');


    }

}