<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;

use Mnv\Models\BannerGroups;

/**
 * Class BannerGroupsAdmin
 * @package Mnv\Admin\Controllers
 */
class BannerGroupsAdmin extends AdminMnv
{

	public function fetch()
    {

        $BannerGroup = new BannerGroups($this->request);

        $this->smarty->assign('activeItem','bannergroups');
        $this->smarty->assign('title', 'Группы баннеров');


        if ($this->action == 'remove') {

            if ($BannerGroup->remove()) {
                $result = array('status' => 200, 'message' => 'Группа баннеров удалена', 'type' => 'success');
            } else {
                $result = array('status' => 403, 'message' => 'Ошибка при удаление группы баннеров', 'type' => 'error');
            }
            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();

        }
        else if ($this->action == 'status') {
            $result = $BannerGroup->status()
                ? array('data' => true, 'status' => $BannerGroup->status, 'type' => 'success')
                : array('data' => false, 'status' => $BannerGroup->status, 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();

        }
        else if ($this->action == 'reorder') {
            $i = 0;
            $BannerGroup->data = [];
            foreach ($BannerGroup->groupIds as $groupId) {
                $i++;
                $BannerGroup->id = $groupId;
                $BannerGroup->data['orderBy'] = $i;
                $BannerGroup->update($BannerGroup->data);
            }

            response()->json(array('status' => 200), \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit;
        }

        $BannerGroups = collect($BannerGroup->all($this->limit, $this->page))->map(function ($item) use ($BannerGroup) {
            $item['statusName']  = lang('general:statuses:' . $item['status']);
            $pages = $BannerGroup->getTracking($item['groupId']);
            if (!empty($pages)) {
                foreach ($pages as $page) {
                    $item['pageNames'][$page] = $BannerGroup->getPageName($page);
                }
            }

            return $item;
        })->all();


        $BannerGroup->total();
        $pages = getPageNums($BannerGroup->total, $this->page, $this->limit, 0, 4, 4, 0);

        $this->smarty->assign('totalGroups', $BannerGroup->total);
        $this->smarty->assign('groups', $BannerGroups);
        $this->smarty->assign('pageNums', $pages);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if ($this->permissions('bannergroups')) {
            return $this->smarty->fetch('views/banners/banner-groups.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }

}